@extends('layouts.app')
@section('title', __('lang_v1.add_purchase_requisition'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('lang_v1.add_purchase_requisition')</h1>
</section>

<!-- Main content -->
<section class="content">
	{!! Form::open(['url' => action([\App\Http\Controllers\PurchaseRequisitionController::class, 'store']), 'method' => 'post', 'id' => 'add_purchase_requisition_form' ]) !!}
	@component('components.widget', ['class' => 'box-solid'])
    <div class="row">
        	<div class="col-sm-4 @if(!session('business.enable_category')) hide @endif">
          		<div class="form-group">
            		{!! Form::label('category_id', __('product.category') . ':') !!}
              		{!! Form::select('category_id[]', $categories, null, ['class' => 'form-control select2', 'multiple', 'id' => 'category_id']); !!}
          		</div>
        	</div>
			<div class="col-sm-4">
          		<div class="form-group">
            		{!! Form::label('priority_level', __('lang_v1.priority_level') . ':') !!}
              		{!! Form::select('priority_level', $priority_levels, null, ['class' => 'form-control select2', 'id' => 'priority_level']); !!}
          		</div>
        	</div>
			@if(count($business_locations) == 1)
				@php 
					$default_location = current(array_keys($business_locations->toArray()));
					$search_disable = false; 
				@endphp
			@else
				@php $default_location = null;
				$search_disable = true;
				@endphp
			@endif
			<div class="col-sm-4">
				<div class="form-group">
					{!! Form::label('location_id', __('purchase.business_location').':') !!}
					{!! Form::select('location_id', $business_locations, $default_location, ['class' => 'form-control select2', 'placeholder' => __('messages.please_select')]); !!}
				</div>
			</div>
        </div>
        <div class="row">
            <div class="col-sm-4">
                <div class="form-group">
                    {!! Form::label('status', __('sale.status') . ':') !!}
                    {!! Form::select('status', $pr_statuses ?? [
                        'requested' => 'Requested',
                        'quoted' => 'Quoted',
                        'for_product_creation' => 'For Product Creation',
                        'request_transfer' => 'Request Transfer',
                        'transfer_approved' => 'Transfer Approved',
                        'approved' => 'Approved',
                        'rejected' => 'Rejected'
                    ], 'requested', ['class' => 'form-control select2', 'required' => true, 'data-rule-required' => 'true']) !!}
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12">
                <label for="search_product_for_pr" class="control-label">@lang('sale.product') - @lang('messages.add')</label>
                <input type="text" id="search_product_for_pr" class="form-control" placeholder="@lang('lang_v1.search_product')" disabled>
                <p class="help-block">@lang('lang_v1.search_product_placeholder')</p>
            </div>
        </div>
	@endcomponent

	@component('components.widget', ['class' => 'box-solid'])
    <div class="row">
        <div class="col-sm-12">
            <div class="form-group">
                {!! Form::label('additional_notes', __('lang_v1.additional_notes') . ':') !!}
                {!! Form::textarea('additional_notes', null, ['class' => 'form-control js-auto-resize-textarea', 'rows' => 3, 'placeholder' => __('lang_v1.additional_notes')]) !!}
            </div>
        </div>
    </div>
@endcomponent

@component('components.widget', ['class' => 'box-solid'])
    <div class="row">
			<div class="col-sm-4">
				<div class="form-group">
					{!! Form::label('ref_no', __('purchase.ref_no').':') !!}
					@show_tooltip(__('lang_v1.leave_empty_to_autogenerate'))
					{!! Form::text('ref_no', null, ['class' => 'form-control']); !!}
				</div>
			</div>
			<div class="col-sm-4">
				<div class="form-group">
					{!! Form::label('delivery_date', __('lang_v1.required_by_date') . ':') !!}
					<div class="input-group">
						<span class="input-group-addon">
							<i class="fa fa-calendar"></i>
						</span>
                        <input type="datetime-local" name="delivery_date" id="delivery_date" class="form-control" value="">
					</div>
				</div>
			</div>
		</div>	
	@endcomponent

	@component('components.widget', ['class' => 'box-solid'])
    <div class="row">
            <div class="col-md-12">
                <table class="table" id="products_list">
					<thead>
                        <tr>
                            <th width="30%">@lang('sale.product')</th>
                            <th width="12%">@lang('product.alert_quantity')</th>
                            <th width="12%">@lang('product.max_quantity')</th>
                            <th width="16%">@lang('purchase.unit_cost')</th>
                            <th width="25%">@lang('lang_v1.required_quantity')</th>
                            <th width="5%"><i class="text-danger fas fa-trash"></i></th>
                        </tr>
                    </thead>
					<tbody>
					</tbody>
				</table>
			</div>
            
		</div>	
	@endcomponent

	<div class="row">
		<div class="col-sm-12 text-center">
			<button type="button" class="tw-dw-btn tw-dw-btn-primary tw-dw-btn-lg tw-text-white" id="submit_pr_form">@lang('messages.save')</button>
		</div>
	</div>

	{!! Form::close() !!}
</section>
@endsection

@section('javascript')
<script type="text/javascript">
$(function(){
  // Enable product search when location selected
  $('select#location_id').on('change', function(){
    if($(this).val()){ $('#search_product_for_pr').removeAttr('disabled'); } else { $('#search_product_for_pr').attr('disabled','disabled'); }
  });

  // Product search for PR (any product)
  if ($('#search_product_for_pr').length > 0) {
    $('#search_product_for_pr')
      .autocomplete({
        source: function(request, response){
          $.getJSON(
            '{{ url('/products/list') }}',
            { location_id: $('#location_id').val(), term: request.term },
            response
          );
        },
        delay: 300,
        minLength: 2,
        response: function(event, ui){
          if(ui.content.length == 1){
            ui.item = ui.content[0];
            $(this).data('ui-autocomplete')._trigger('select', 'autocompleteselect', ui);
            $(this).autocomplete('close');
          } else if(ui.content.length == 0){
            swal(LANG.no_products_found);
          }
        },
        select: function(event, ui){
          $(this).val(null);
          pr_add_product_row(ui.item.variation_id);
        }
      })
      .autocomplete('instance')._renderItem = function(ul, item){
        var label = '<div>' + item.name + (item.type=='variable' ? (' - ' + item.variation) : '') + ' (' + item.sub_sku + ')</div>';
        return $('<li>').append(label).appendTo(ul);
      };
  }

  window.pr_add_product_row = function(variation_id){
    $.ajax({
      method:'post',
      url: '{{ route('pr.get_product_row') }}',
      data: { variation_id: variation_id, location_id: $('#location_id').val(), _token: $('meta[name="csrf-token"]').attr('content') },
      success: function(result){
        var rows = $(result);
        rows.find('tr').each(function(){
          var id = $(this).attr('data-variation_id');
          if ($('tr[data-variation_id="' + id + '"]').length == 0) {
            $('#products_list tbody').append($(this));
          }
        });
      }
    });
  }

  // Existing save button triggers form submit
  $('#submit_pr_form').on('click', function(){
    $('#add_purchase_requisition_form').submit();
  });
});
</script>
@endsection

@section('javascript')
    <style>
        /* Ensure the datepicker renders above tables & widgets */
        .bootstrap-datetimepicker-widget,
        .bootstrap-datetimepicker-widget.dropdown-menu,
        .daterangepicker {
            z-index: 2050 !important; /* above modals/tooltips */
        }
    </style>
    <script type="text/javascript">
		$(document).ready( function(){
            if (typeof window.initAutoResizeTextareas !== 'function') {
                window.initAutoResizeTextareas = function(context){
                    $(context || document).find('textarea.js-auto-resize-textarea').each(function(){
                        var el = this;
                        var $el = $(el);
                        if (!$el.data('autoResizeMinHeight')) {
                            var rows = parseInt($el.attr('rows'), 10) || 2;
                            var lineHeight = parseFloat($el.css('line-height')) || 20;
                            $el.data('autoResizeMinHeight', rows * lineHeight);
                        }
                        var minHeight = $el.data('autoResizeMinHeight');
                        var resize = function(){
                            el.style.height = 'auto';
                            var newHeight = Math.max(el.scrollHeight, minHeight);
                            el.style.height = (newHeight + 2) + 'px';
                        };
                        $el.css('overflow', 'hidden');
                        resize();
                        $el.off('input.autoResize').on('input.autoResize', resize);
                    });
                };
            }
            window.initAutoResizeTextareas();
      		__page_leave_confirmation('#add_purchase_requisition_form');
            var $dd = $('#delivery_date');
            // Only initialize legacy picker if input is a plain text field
            if ($dd.attr('type') === 'text') {
                $dd.datetimepicker({
                    format: moment_date_format + ' ' + moment_time_format,
                    ignoreReadonly: true,
                    widgetParent: 'body',
                    allowInputToggle: true,
                    showClose: true
                });
                // Fallback: ensure click focuses and opens widget
                $dd.on('focus', function(){ $(this).data('DateTimePicker') && $(this).data('DateTimePicker').show(); });
            }

            $('#show_pr_products').click( function(){
            	if ($('#location_id').val() == '') {
            		alert('{{__("lang_v1.select_location")}}');
            		return false;
            	}
            	var data = {
	            	location_id: $('#location_id').val(),
	            	category_id: $('#category_id').val()
	            }

            	$.ajax({
                    method: 'post',
                    url: "{{route('get-requisition-products')}}",
                    dataType: 'html',
                    data: data,
                    success: function(result) {
                    	var rows = $(result);
                    	rows.find('tr').each(function(){
                    		var row_variation_id = $(this).attr('data-variation_id');
                    		if ($('tr[data-variation_id="' + row_variation_id + '"]').length == 0) {
                    			$('#products_list tbody').append($(this));
                    		}
                    	})
                        
                    },
                });
            });
    	});

		var prev_location;

		$('#location_id').on('select2:selecting', function(){
		    prev_location = $(this).val();
		})

		$('#location_id').on('select2:select', function(){
			if ($('#products_list tbody').find('tr').length > 0){
        		swal({
		            title: LANG.sure,
		            text: '{{__("lang_v1.all_added_products_will_be_removed")}}',
		            icon: 'warning',
		            buttons: true,
		            dangerMode: true,
		        }).then(willDelete => {
		            if (willDelete) {
		                $('#products_list tbody').html('');
		            } else {
		        		$('#location_id').val(prev_location);
		        		$('#location_id').change();
		        		return false;
		        	}
		        });
        	}
		});

    	// Remove a product row (delegated for dynamically added rows)
    	$(document).on('click', '.remove_product_line', function(e){
    		e.preventDefault();
    		$(this).closest('tr').remove();
    	});

    	$(document).on('click', 'button#submit_pr_form', function(e){
    		e.preventDefault();
    		var has_rows = $('#products_list tbody').find('tr').length > 0;
            var has_notes = $.trim($('#additional_notes').val() || '') !== '';
            if (!has_rows && !has_notes) {
                toastr.warning(LANG.no_products_added);
                return false;
            }
    		if ($('form#add_purchase_requisition_form').valid()) {
    			$('form#add_purchase_requisition_form').submit();
    		}
    	})
	</script>
@endsection
